#ifndef _PROP_DOOR_H
#define _PROP_DOOR_H

#include "Prop.h"

class PropDoor : public Prop
{   
protected:
    Quat rotClosed = Quat_IDENTITY;
    Quat rotTo = Quat_IDENTITY;
    float speed = 3.0f;
    bool isLocked = false;
    bool isOpen = false;
    bool swordOpen = true;
    u8 unlockFlag = 0;
    bool autoOpen = false;

public:
    PropDoor(MapEntityType type = MapEntityType_Door) : Prop(type) {}

    virtual void Start();

    virtual void LoadDoorModel();

    void Update(float dt);

    void Open();
    void SetOpen(bool value, bool force = false);

    inline bool IsLocked() const { return isLocked; }
    inline bool IsOpen() const { return isOpen; }

    bool ShouldBeOpen();
    bool ShouldBeUnlocked();

};

#endif