#ifndef _PROP_CUPBOARD_H
#define _PROP_CUPBOARD_H

#include "Prop.h"
#include <SoundPlayer.h>

// anims: open,shut

class PropCupboard : public Prop
{
private:
    ModelAnimData * animOpen = NULL;
    ModelAnimData * animShut = NULL;
    bool isOpen = false;

public:

    PropCupboard() : Prop(MapEntityType_Cupboard) {}

    void Start()
    {
        radius = 1.0f;
        Prop::Start();
        LoadModel("models/cupboard.iqm", "mats/wooddarkb.png");
        animOpen = model.FindAnimation("open");
        animShut = model.FindAnimation("shut");
        SetCollision(CollisionMode_Collide);
        useGravity = false;
        canDespawn = false;
        SetOpen(false);
    }

    void Update(float dt)
    {
        Prop::Update(dt);
        model.Update(dt);
    }

    void SetOpen(bool value)
    {
        if (value != isOpen && value)
        {
            SoundPlayer::Inst().Play("sfx/door.wav");
        }
        isOpen = value;
        model.BlendAnimation(isOpen ? animOpen : animShut, 0.2f);
    }

    inline bool IsOpen() const { return isOpen; }
};

#endif