#ifndef _PROP_BOULDER_H
#define _PROP_BOULDER_H

#include "PushableProp.h"
#include "SoundPlayer.h"

class PropBoulder : public PushableProp
{
public:
    PropBoulder() : PushableProp(MapEntityType_Boulder, UINT16_MAX) {}

    void Start()
    {
        radius = 0.6f;
        PushableProp::Start();
        LoadModel("models/boulder.iqm", "mats/rock.png");
        modelOffset.y = 0.8f;
        maxGradient = 0.3f;
        SetCollision(CollisionMode_Resolve, Vector3(1.1f), Vector3(0.0f, 0.6f, 0.0f));
    }
    
    virtual void OnSpaceChange() 
    {
        if (TileMap::IsCornerType(mapTile.type))
        {
            Vector3 cornerDir = Maths::Normalize(TileMap::GetCornerForward(mapTile.type));
            pushDirection = Maths::Cardinal(pushDirection - cornerDir);
            isMoving = true;
            SoundPlayer::Inst().Play("sfx/thud3.wav", 0.6f);
            FXer::Fire(this, FXType_Dust, Vector3_UP);
        }
    }

    void UpdateAnimation(float dt)
    {
        if (isMoving)
        {
            float length = Maths::Length(moveVelocity);
            Vector3 axis = Maths::Normalize(moveVelocity);
            axis = Maths::Cross(axis, Vector3_UP);
            transform.rotation = glm::angleAxis(length * -dt, axis) * transform.rotation;
        }
    }

    void OnCollision(Entity * other)
    {
        PushableProp::OnCollision(other);
    }
};

#endif