#ifndef _PROP_BLOCK_RAISE_LOWER_H
#define _PROP_BLOCK_RAISE_LOWER_H

#include "Prop.h"
#include <Maths.h>
#include <SoundPlayer.h>

class PropBlockRaiseLower : public Prop
{
protected:
    bool inverted = false;
    bool isActive = false;
    Vector3 posTo = Vector3_ZERO;
    
protected:
    PropBlockRaiseLower(MapEntityType type) : Prop(type) {}

    void Start()
    {
        radius = 1.1f;
        Prop::Start();
        LoadModel("models/rockblock.iqm", "mats/rock.png");
        SetCollision(CollisionMode_Collide, Vector3(2, 0.9f, 2), Vector3(0, 1, 0));
        collider->mass = 1000;
        useGravity = false;
        canDespawn = false;
        posTo = spawnPos;
        isActive = map->FlagIsSet(info->flag) != inverted;
        if (isActive)
        {
            posTo.y -= 1.5f;
            isVisible = posTo.y > MAP_WATER_HEIGHT;
            if (isVisible == false)
            {
                collider->mode = CollisionMode_None;
            }
        }
        transform.position = posTo;
        useCulling = false;
    }

    void Update(float dt)
    {
        MapEntity::Update(dt);

        bool nowActive = map->FlagIsSet(info->flag) != inverted;
        if (nowActive != isActive)
        {
            posTo = spawnPos;
            if (nowActive)
            {
                posTo.y -= 1.5f;
                collider->mode = CollisionMode_None;
                isVisible = spawnPos.y > MAP_WATER_HEIGHT;
                if (isVisible == false)
                {
                    collider->mode = CollisionMode_None;
                }
            }
            else
            {
                collider->mode = CollisionMode_Collide;
                isVisible = true;
            }
            SoundPlayer::Inst().Play("sfx/slide.wav");
            isActive = nowActive;
        }

        Vector3 move = posTo - transform.position;
        move = Maths::Clamp(move, dt * 10.0f);
        transform.position += move;
    }
};


class PropBlockLower : public PropBlockRaiseLower
{
public:
    PropBlockLower() : 
        PropBlockRaiseLower(MapEntityType_BlockLower)
    {
        inverted = false;
    }
};


class PropBlockRaise : public PropBlockRaiseLower
{
public:
    PropBlockRaise() : 
        PropBlockRaiseLower(MapEntityType_BlockRaise)
    {
        inverted = true;
    }
};


#endif