#ifndef _PROP_H
#define _PROP_H

#include <MapEntity.h>
#include <MeshRenderer.h>
#include <Model3D.h>

class Prop : public MapEntity
{
protected:
    Vector3 modelOffset = Vector3_ZERO;
    Model3D model;

public:
    Prop(MapEntityType type) : MapEntity(type) {}

    virtual void Start()
    {   
        SetCollision(CollisionMode_Collide);
        MapEntity::Start();
        useGravity = false;
        canDespawn = false;
    }

    void LoadModel(const char * modelPath, const char * texturePath, float scale = 1.0f)
    {
        model.LoadModel(modelPath, scale);
        model.SetMaterial(texturePath);
    }

    void Render()
    {
        Matrix mtx = glm::translate(Matrix(1.0f), modelOffset);
        mtx *= transform.GetMatrix();
        model.Render(mtx);
    }
};

#endif