#ifndef _PICKUP_H
#define _PICKUP_H

#include "Prop.h"

class Pickup : public Prop
{
protected:
    float angle = 0.0f;
    bool canPickup = true;

public:
    Pickup(MapEntityType type) : Prop(type) {}

    virtual void Start()
    {
        if (map != NULL && map->FlagIsSet(info->id))
        {
            Remove();
            return;
        }
        Prop::Start();
        SetCollision(CollisionMode_Receive);
    }

    void Update(float dt)
    {
        angle += dt;
        transform
            .SetPosition(spawnPos + Vector3(0, sinf(angle) * 0.2f + 0.5f, 0))
            .LookAt(transform.position + Vector3(cosf(angle), 0, sinf(angle)));

        bool canPickupNow = info->flag == 0 || map->FlagIsSet(info->flag);
        if (canPickupNow != canPickup)
        {
            canPickup = canPickupNow;
            SetCollision(canPickup ? CollisionMode_Receive : CollisionMode_None);
        }
    }

    void Render()
    {
        if (canPickup == false)
            return;

        Prop::Render();
    }
};

#endif