#ifndef _MODEL_PROP_H
#define _MODEL_PROP_H

#include "Prop.h"
#include <desslog.h>

class ModelProp : public Prop
{
public:

    ModelProp() : Prop(MapEntityType_Model) {}

    void Start()
    {
        Prop::Start();

        const char * modelPath = NULL;
        const char * texturePath = NULL;

        if (info->cmdCount > 0)
        {
            for (u8 i=0; i<info->cmdCount; i++)
            {
                const MapCmd * cmd = &map->data.cmds[info->cmdFirst + i];
                if (cmd->type == MapCmd_MODEL)
                {
                    modelPath = map->data.messages[cmd->value].Text();
                }
                else if (cmd->type == MapCmd_TEXTURE)
                {
                    texturePath = map->data.messages[cmd->value].Text();
                }
            }
        }

        if (modelPath == NULL)
        {
            Log_Error("No model found on %s\n ", info->name.Text());
            return;
        }

        if (texturePath == NULL)
        {
            Log_Error("No texture found on %s\n ", info->name.Text());
            return;
        }

        LoadModel(modelPath, texturePath);        
        SetCollision(CollisionMode_None);
        useGravity = false;
        canDespawn = false;
        useCulling = false;
    }
};

#endif
