#ifndef _MAP_PRELOADER
#define _MAP_PRELOADER

#include <dessint.h>
#include <Hash.h>

class TileMap;
struct TileMapLoadInfo;
class Scene;

class MapPreloader
{
private:
	static MapPreloader * current;
	TileMap * map = NULL;
	TileMapLoadInfo * loadInfo = NULL;
	HashInt mapHash = 0;
	Scene * loadScene = NULL;

public:
	static MapPreloader * Current();

	MapPreloader(HashInt hash, u16 loadFlags);
	virtual ~MapPreloader();

	void SetCurrent();
	void Continue();
	void Finish();
	void Unload();

	bool IsLoading() const;
	inline TileMap * GetMap() const { return map; }
	inline HashInt GetHash() const { return mapHash; }
};

#endif