#include "MapPreloader.h"
#include <TileMap.h>
#include <MapEntityFactory.h>
#include <MapData.h>
#include <Scene.h>

MapPreloader * MapPreloader::current = NULL;
MapPreloader * MapPreloader::Current()
{
	return current;
}

MapPreloader::MapPreloader(HashInt hash, u16 loadFlags) : mapHash(hash)
{
	loadScene = new Scene();
	map = new TileMap();
	map->SetEntityFactory(new MapEntityFactory());
	loadScene->AddEntity(map);

	if (current == NULL)
	{
		SetCurrent();
	}

	std::string path = MapUtils::MapHashToPath(hash);
	loadInfo = map->Load(path.c_str(), loadFlags);
	loadInfo->entitiesPerFrame = 5;
}

MapPreloader::~MapPreloader() 
{
	map->Unload();
	loadScene->OnUnload();
	delete map;
	delete loadScene;
	map = NULL;
	loadScene = NULL;
}

void MapPreloader::SetCurrent()
{
	current = this;
}

void MapPreloader::Continue()
{
	if (IsLoading())
	{
		map->LoadContinue();
	}
}

void MapPreloader::Finish()
{
	while (IsLoading())
	{
		Continue();
	}
}

bool MapPreloader::IsLoading() const
{
	return loadInfo != NULL && loadInfo->state < TileMapLoadState_COMPLETE;
}

void MapPreloader::Unload()
{
	map->Unload();
	current = NULL;
	loadInfo = NULL;
}
