#ifndef _SHADOW_H
#define _SHADOW_H

#include <MeshRenderer.h>
#include <Mesh.h>
#include <Material.h>
#include <Ref.h>
#include <MapEntity.h>
#include <Primatives.h>
#include <Maths.h>

class Shadow
{
private:
    MapEntity * owner;
    Ref<Material> mat;
    MeshRenderer renderer;
    Mesh mesh;

public:
    Shadow(MapEntity * entity, float size = 2.0f) : owner(entity)
    {
        Primatives::Quad(Vector3_UP, Vector2(size), &mesh);
        mat = Material::Load("mats/shadow.png", "shaders/particle.dsh");
        mesh.SetMaterial(mat);
    }

    virtual ~Shadow()
    {

    }

    void Render()
    {
        if (Entity::IsActive(owner) == false)
            return;

        Vector3 pos = owner->transform.position;
        pos.y = Maths::Min(owner->map->GetHeight(pos), pos.y) + 0.01f;
        Matrix mtx = glm::translate(Matrix(1.0f), pos);
        renderer.Render(&mesh, mtx);
    }
};

#endif