#include "FXer.h"
#include <Actor.h>
#include "FXPool.h"
#include "FXStrikeSword.h"
#include "FXStrikeAxe.h"
#include "FXStrikeUnarmed.h"
#include "FXFireball.h"
#include "FXIceball.h"
#include "FXExplosion.h"
#include "FXElectroBlast.h"
#include "FXEvaporate.h"
#include "FXElectric.h"
#include "FXLove.h"
#include "FXChicken.h"
#include "FXHeart.h"
#include "FXGrass.h"
#include "FXWoodchip.h"
#include "FXDust.h"

#define POOL_SIZE 4
Entity * FXER_OWNER = new Entity();
std::vector<FXEntity*> FXer::entities;

FXEntity * FXer::Fire(Entity * owner, FXType type, Vector3 offset)
{
    FXEntity * inst = NULL;
    switch (type)
    {
        case FXType_Sword:
        {
            static FXPool<FXStrikeSword> pool(POOL_SIZE);
            inst = pool.Next();
            break;
        }
        
        case FXType_Axe:
        {
            static FXPool<FXStrikeAxe> pool(POOL_SIZE);
            inst = pool.Next();
            break;
        }

        case FXType_Unarmed:
        {
            static FXPool<FXStrikeUnarmed> pool(POOL_SIZE);
            inst = pool.Next();
            break;
        }

        case FXType_Fireball:
        {
            static FXPool<FXFireball> pool(POOL_SIZE);
            inst = pool.Next();
            break;
        }

        case FXType_Iceball:
        {
            static FXPool<FXIceball> pool(POOL_SIZE);
            inst = pool.Next();
            break;
        }
        
        case FXType_Electric:
        {
            static FXPool<FXElectric> pool(POOL_SIZE);
            inst = pool.Next();
            break;
        }

        case FXType_Explosion:
        {
            static FXPool<FXExplosion> pool(POOL_SIZE);
            inst = pool.Next();
            break;
        }

        case FXType_ElectroBlast:
        {
            static FXPool<FXElectroBlast> pool(POOL_SIZE);
            inst = pool.Next();
            break;
        }

        case FXType_Evaporate:
        {
            static FXPool<FXEvaporate> pool(POOL_SIZE);
            inst = pool.Next();
            break;
        }

        case FXType_Love:
        {
            static FXPool<FXLove> pool(POOL_SIZE);
            inst = pool.Next();
            break;
        }

        case FXType_Chicken:
        {
            static FXPool<FXChicken> pool(16);
            inst = pool.Next();
            break;
        }

        case FXType_Heart:
        {
            static FXPool<FXHeart> pool(3);
            inst = pool.Next();
            break;
        }

        case FXType_Grass:
        {
            static FXPool<FXGrass> pool(8);
            inst = pool.Next();
            break;
        }
        
        case FXType_Woodchips:
        {
            static FXPool<FXWoodchip> pool(8);
            inst = pool.Next();
            break;
        }

        case FXType_Dust:
        {
            static FXPool<FXDust> pool(8);
            inst = pool.Next();
            break;
        }

    }
    if (inst == NULL)
        return NULL;
        
    if (inst->entityOwner != FXER_OWNER)
    {
        inst->entityOwner = FXER_OWNER;
        entities.push_back(inst);
    }
    inst->transform.position = offset;
    if (owner != NULL)
    {
        inst->transform.position += owner->transform.position;
    }
    inst->Fire(owner);
    inst->SetEnabled(true);
    return inst;
}

FXType FXer::GetSwordProjectile(MapEntityType mapEntityType)
{
    switch (mapEntityType)
    {
        case MapEntityType_Sword:
            return FXType_Sword;

        case MapEntityType_Axe:
            return FXType_Axe;

        case MapEntityType_SwordFire:
            return FXType_Fireball;

        case MapEntityType_SwordIce:
            return FXType_Iceball;

        case MapEntityType_SwordElectric:
            return FXType_Electric;
    }
    return FXType_Unarmed;
}

void FXer::Clear()
{
    for (std::vector<FXEntity*>::iterator it = entities.begin(); it != entities.end(); ++it)
    {
        if ((*it) != NULL && (*it)->IsEnabled())
        {
            (*it)->SetEnabled(false);
        }
    }
}