#ifndef _FX_WOODCHIP_H
#define _FX_WOODCHIP_H

#include "FXParticles.h"
#include "Camera.h"

class FXWoodchip : public FXParticles
{
public:
    FXWoodchip() : 
        FXParticles(10, "mats/woodchip.png")
    {
        spin = 1.0f;
        startSize = 0.4f;
        lifeTime = 0.5f;
        grow = 0.0f;
        spread = 3.0f;
        damage = 4;
        renderMode = RenderMode_Standard;
    }

    void OnEnabled()
    {
        FXParticles::OnEnabled();
        velocity = Vector3(0, 10, 0);
    }
    
    void Update(float dt)
    {
        FXParticles::Update(dt);
        velocity.y -= dt * 50.0f;
    }
};

#endif