#ifndef _FX_STRIKE_UNARMED_H
#define _FX_STRIKE_UNARMED_H

#include "FXStrikeEntity.h"

class Actor;

class FXStrikeUnarmed : public FXStrikeEntity
{
public:
    void Start()
    {
        FXStrikeEntity::Start();
        collider->size = Vector3(0.7f);
        collider->center = Vector3_BACK;
        model->transform.SetScale(-0.4f).SetPosition(Vector3(0, 0, 0.2f));
        damage = 0;
    }

    void OnEnabled()
    {
        collider->center = owner->transform.Forwards() * 0.5f;
        PlaySound("sfx/strike_key.wav");
    }

};

#endif