#ifndef _FX_STRIKE_ENTITY_H
#define _FX_STRIKE_ENTITY_H

#include "FXEntity.h"
#include <Collider.h>
#include <Model3D.h>

class Actor;

class FXStrikeEntity : public FXEntity
{
public:
    virtual void Fire(Entity * owner)
    {   
        transform.position = owner->transform.position + owner->transform.Forwards() * 0.3f + Vector3(0.0f, 0.6f, 0.0f);
        FXEntity::Fire(owner);
    }

    virtual void Start()
    {
        collider = new Collider(this, Vector3(1.0f), Vector3_FORWARD);
        collider->mode = CollisionMode_Receive;
        model = new Model3D();
        model->SetMaterial("mats/white.png");
        model->transform.SetScale(-1.0f).SetPosition(Vector3(0, 0, 0.5f));
        damage = 1;
    }

    virtual void OnEnabled()
    {
        collider->center = owner->transform.Forwards();
        PlaySound("sfx/strike_sword.wav");
    }
};

#endif