#ifndef _FX_STRIKE_AXE_H
#define _FX_STRIKE_AXE_H

#include "FXStrikeEntity.h"

class Actor;

class FXStrikeAxe : public FXStrikeEntity
{
public:
    virtual void Start()
    {
        FXStrikeEntity::Start();
        collider->size = Vector3(1.5f);
        collider->center = Vector3_FORWARD * 0.5f;
        model->transform.SetScale(-1.5f).SetPosition(Vector3_BACK);
        damage = 2;
    }
    
    void OnEnabled()
    {
        collider->center = owner->transform.Forwards() * 0.8f;
        PlaySound("sfx/strike_axe.wav");
    }
};

#endif