#ifndef _FX_PROJECTILE_H
#define _FX_PROJECTILE_H

#include "FXEntity.h"
#include <Collider.h>
#include "dessgeom.h"
#include <Maths.h>
#include "FXer.h"
#include <Model3D.h>
#include <MapEntity.h>
#include <TileMap.h>

class Actor;

class FXProjectile : public FXEntity
{
public:
    const char * modelPath = "models/fireball.iqm";
    const char * matPath = "mats/fire.png";
    const char * fireSound = "sfx/strike_fire.wav";
    FXType explosionType = FXType_Explosion;
    TileMap * map = NULL;

    void Start()
    {
        collider = new Collider(this, Vector3(2.0f));
        collider->mode = CollisionMode_Receive;
        collider->mass = 10;
        model = new Model3D();
        model->LoadModel(modelPath, matPath);
        transform.scale = Vector3(0.7f);
        damage = 4;
        lifeTime = 10.0f;
    }

    void OnEnabled()
    {
        PlaySound(fireSound);
        transform.position += Vector3(0, 0.5f, 0);

        map = NULL;
        if (Actor::IsActive(owner))
        {
            map = ((Actor *)owner)->map;
        }
    }

    void Update(float dt)
    {
        FXEntity::Update(dt);
        Vector3 forwards = transform.Forwards();
        transform.position += forwards * dt * 15.0f;
        transform.rotation *= Quat(Vector3(0, 0, dt * 100.0f));
        if (map != NULL)
        {
            float groundY = map->GetHeight(transform.position);
            if (groundY > transform.position.y + 0.5f)
            {
                SetEnabled(false);
                Entity * explosion = FXer::Fire(owner, explosionType);
                explosion->transform.position = transform.position;
            }
        }
    }

    void OnCollision(Entity * other)
    {
        if (other != NULL && ((MapEntity *)other)->GetType() == MapEntityType_Grass)
        {
            ((MapEntity *)other)->TakeHit(owner, damage);
            return;
        }

        FXEntity::OnCollision(other);
        if (other != owner && other != NULL)
        {
            SetEnabled(false);
            Entity * explosion = FXer::Fire(owner, explosionType);
            explosion->transform.position = other->transform.position;
        }
    }
};


#endif
