#ifndef _FX_POOL_H
#define _FX_POOL_H

#include <dessint.h>

template <class T>
class FXPool
{
private:
    u16 count;
    u16 next;
    T * instances;

public:
    FXPool(u16 count) : count(count), next(0) 
    {
        instances = new T[count];
    }

    T * Next()
    {
        u16 index = next;
        next++;
        if (next >= count)
        {
            next = 0;
        }
        return &instances[index];
    }
};

#endif