#ifndef _FX_PARTICLES_H
#define _FX_PARTICLES_H

#include "FXEntity.h"
#include "Mesh.h"
#include "Material.h"
#include "RenderWindow.h"

struct ParticleBit
{
    Vector3 position = Vector3_ZERO;
    Vector3 velocity = Vector3_ZERO;
    float angle = 0.0f;
    float scale = 1.0f;
    float spin = 0.0f;
};

class FXParticles : public FXEntity
{
protected:
    const u8 count = 0;
    float spin = 1.0f;
    float spread = 1.0f;
    float grow = 1.0f;
    float startSize = 1.0f;
    Vector3 velocity = Vector3_ZERO;
    ParticleBit * bits = NULL;
    Mesh mesh;
    MeshRenderer renderer;
    RenderMode renderMode = RenderMode_Depthless;
    Ref<Material> material;

public:
    FXParticles(u8 count, const char * texturePath);
    virtual ~FXParticles();

    virtual void Start();

    virtual void OnEnabled();

    virtual void Update(float dt);
    
    virtual void Render();
};

#endif