#ifndef _FX_LOVE_H
#define _FX_LOVE_H

#include "FXParticles.h"
#include "Camera.h"

class FXLove : public FXParticles
{
public:
    FXLove() : 
        FXParticles(6, "mats/love.png")
    {
        spin = 0.0f;
        startSize = 0.4f;
        lifeTime = 0.5f;
        grow = 1.0f;
        spread = 3.0f;
        damage = 4;
        collider = new Collider(this, Vector3(3, 3, 3), Vector3(0, 1, 0));
        collider->mode = CollisionMode_Receive;
    }

    void OnEnabled()
    {
        FXParticles::OnEnabled();
        Camera * cam = Camera::Current();
        if (cam != NULL)
        {
            cam->Shake(3.0f);
        }
        PlaySound("sfx/explosion.wav");
    }
};

#endif