#ifndef _FX_HEART_H
#define _FX_HEART_H

#include "FXEntity.h"
#include <Collider.h>
#include "dessgeom.h"
#include <Maths.h>
#include "FXer.h"
#include <Model3D.h>

class Actor;

#define MOVE_SPREAD 6.0f

class FXHeart : public FXEntity
{
private:
    float fall = 0.0f;
    Vector3 move = Vector3_ZERO;
    bool pickedUp = false;
    float groundY = 0.0f;

public:
    void Start()
    {
        collider = new Collider(this, Vector3(2.0f));
        collider->mode = CollisionMode_Receive;
        collider->mass = 10;
        model = new Model3D();
        model->LoadModel("models/heart.iqm", 0.5f);
        model->SetMaterial("models/heart.png");
        damage = 0;
        lifeTime = 10.0f;
        move = Vector3(Maths::RandFSigned(MOVE_SPREAD), 0, Maths::RandFSigned(MOVE_SPREAD));
        fall = Maths::RandF(-8.0f, -20.0f);
        transform.LookDirection(Vector3_BACK);
    }

    void OnEnabled()
    {
        pickedUp = false;
        groundY = Entity::NotDestroyed(owner) ? ((MapEntity*)owner)->map->GetHeight(owner->transform.position) : 0.0f;
    }

    void Update(float dt)
    {
        FXEntity::Update(dt);
        if (transform.position.y < groundY && fall > 0.0f)
        {
            fall = -3.0f;
            transform.position.y = groundY;
        }
        else
        {
            fall += 1.0f;
        }
        transform.position.y -= fall * dt;
        transform.position += move * dt;
        move *= 1.0f - Maths::DeltaEase(0.1f, dt);
    }
    
    void OnCollision(Entity * other)
    {
        if (pickedUp)
            return;

        if (time < 0.3f)
            return;

        Actor * otherActor = (Actor*)other;
        if (otherActor != NULL && otherActor->type == MapEntityType_Player)
        {
            SetEnabled(false);
            pickedUp = true;
            if (otherActor->inventory.hearts < otherActor->inventory.maxHearts)
            {
                otherActor->inventory.hearts++;
            }
            PlaySound("sfx/pickup.wav");
        }
    }
};

#endif