#ifndef _FX_GRASS_H
#define _FX_GRASS_H

#include "FXParticles.h"
#include "Camera.h"

class FXGrass : public FXParticles
{
public:
    FXGrass() : 
        FXParticles(6, "mats/clipping.png")
    {
        spin = 1.0f;
        startSize = 0.5f;
        lifeTime = 1.0f;
        grow = 0.0f;
        spread = 3.0f;
        damage = 4;
        renderMode = RenderMode_Standard;
    }

    void OnEnabled()
    {
        FXParticles::OnEnabled();
        velocity = Vector3(0, 10, 0);
    }
    
    void Update(float dt)
    {
        FXParticles::Update(dt);
        velocity.y -= dt * 50.0f;
    }
};

#endif