#ifndef _FX_EXPLOSION_H
#define _FX_EXPLOSION_H

#include "FXParticles.h"
#include "Camera.h"

class FXExplosion : public FXParticles
{
public:
    FXExplosion() : 
        FXParticles(6, "mats/explosion.png")
    {
        spin = 3.0f;
        startSize = 2.0f;
        lifeTime = 0.5f;
        grow = 2.5f;
        spread = 3.0f;
        damage = 4;
    }

    void OnEnabled()
    {
        FXParticles::OnEnabled();
        Camera * cam = Camera::Current();
        if (cam != NULL)
        {
            cam->Shake(3.0f);
        }
        PlaySound("sfx/explosion.wav", 0.5f);
    }
};

#endif