#ifndef _FX_EVAPORATE_H
#define _FX_EVAPORATE_H

#include "FXParticles.h"
#include "Camera.h"

class FXEvaporate : public FXParticles
{
public:
    FXEvaporate() : 
        FXParticles(5, "mats/evaporate.png")
    {
        spin = 6.0f;
        startSize = 0.5f;
        lifeTime = 0.5f;
        grow = 1.3f;
        spread = 2.0f;
    }

    void OnEnabled()
    {
        FXParticles::OnEnabled();
        Camera * cam = Camera::Current();
        if (cam != NULL)
        {
            cam->Shake(1.0f);
        }
        PlaySound("sfx/evaporate.wav");
    }
};

#endif