#ifndef _FX_ENTITY_H
#define _FX_ENTITY_H

#include <Entity.h>
#include <MeshRenderer.h>

class Actor;
class Model3D;

#define NO_DAMAGE UINT8_MAX

class FXEntity : public Entity
{
protected:
    Model3D * model = NULL;
    float time = 0.0f;
    Entity * owner = NULL;
    u8 damage = NO_DAMAGE;
    float lifeTime = 0.2f;

public:
    virtual ~FXEntity();

    virtual void Fire(Entity * owner);

    virtual void Start() {}

    virtual void OnEnabled() {}

    virtual void Update(float dt);

    virtual void Render();

    virtual void OnCollision(Entity * other);

    void PlaySound(const char * path, float value = 1.0f);
};

#endif