#include "FXEntity.h"
#include <Scene.h>
#include <Actor.h>
#include <Collider.h>
#include <MapEntity.h>
#include <SoundPlayer.h>

FXEntity::~FXEntity()
{
    if (model != NULL)
    {
        delete model;
    }
}

void FXEntity::Fire(Entity * _owner)
{
    owner = _owner;
    owner->scene->AddEntity(this);
    Vector3 forwards = owner->transform.Forwards();
    transform.LookDirection(forwards);
    time = 0.0f;
    SetEnabled(true);
}

void FXEntity::Update(float dt)
{
    time += dt;
    if (time > lifeTime)
    {
        SetEnabled(false);
    }
}

void FXEntity::PlaySound(const char * path, float volume)
{
    SoundPlayer::Inst().Play(path, volume);
}

void FXEntity::OnCollision(Entity * other)
{
    if (damage == NO_DAMAGE)
        return;
    if (Entity::IsActive(other) && other != owner && Actor::IsActor(owner))
    {
        ((Actor*)owner)->OnStrike((MapEntity*)other, damage);
    }
}

void FXEntity::Render()
{
    Matrix mtx = transform.GetMatrix();
    mtx = glm::translate(mtx, Vector3_BACK);
    model->Render(mtx);
}