#ifndef _FX_ELECTROBLAST_H
#define _FX_ELECTROBLAST_H

#include "FXParticles.h"
#include "Camera.h"

class FXElectroBlast : public FXParticles
{
public:
    FXElectroBlast() : 
        FXParticles(3, "mats/electroblast.png")
    {
        spin = 3.0f;
        startSize = 2.0f;
        lifeTime = 0.5f;
        grow = 2.5f;
        spread = 3.0f;
        damage = 4;
    }

    void OnEnabled()
    {
        FXParticles::OnEnabled();
        Camera * cam = Camera::Current();
        if (cam != NULL)
        {
            cam->Shake(3.0f);
        }
        PlaySound("sfx/explosion.wav", 0.5f);
    }
};

#endif