#ifndef _FX_CHICKEN_H
#define _FX_CHICKEN_H

#include "FXEntity.h"
#include <Collider.h>
#include "dessgeom.h"
#include <Maths.h>
#include "FXer.h"
#include <Model3D.h>
#include <Entity.h>
#include <Actor.h>

class Actor;

#define MOVE_SPREAD 6.0f

class FXChicken : public FXEntity
{
private:
    float fall = 0.0f;
    Vector3 move = Vector3_ZERO;
    bool pickedUp = false;
    float groundY = 0.0f;

public:
    void Start()
    {
        collider = new Collider(this, Vector3(2.0f));
        collider->mode = CollisionMode_Receive;
        collider->mass = 10;
        model = new Model3D();
        model->LoadModel("models/chicken.iqm", 0.5f);
        model->SetMaterial("models/chook.png");
        damage = 0;
        lifeTime = 10.0f;
        move = Vector3(Maths::RandFSigned(MOVE_SPREAD), 0, Maths::RandFSigned(MOVE_SPREAD));
        fall = Maths::RandF(-8.0f, -20.0f);
        transform.rotation *= Quat(Vector3(0, Maths::RandF(360.0f), 0));
    }

    void OnEnabled()
    {
        pickedUp = false;
        groundY = 0.0f;
    }

    void Update(float dt)
    {
        FXEntity::Update(dt);

        transform.rotation *= Quat(Vector3(0, dt, 0));

        if (Entity::NotDestroyed(owner))
        {
            groundY = ((MapEntity*)owner)->map->GetHeight(owner->transform.position);
        }

        if (transform.position.y < groundY && fall > 0.0f)
        {
            fall = -3.0f;
            transform.position.y = groundY;
        }
        else
        {
            fall += 1.0f;
        }
        transform.position.y -= fall * dt;
        transform.position += move * dt;
        move *= 1.0f - Maths::DeltaEase(0.1f, dt);
    }
    
    void OnCollision(Entity * other)
    {
        if (pickedUp)
            return;

        if (time < 0.3f)
            return;

        Actor * otherActor = (Actor*)other;
        if (otherActor != NULL && otherActor->type == MapEntityType_Player)
        {
            SetEnabled(false);
            pickedUp = true;
            otherActor->inventory.chicken++;
            PlaySound("sfx/pickup.wav");
        }
    }
};

#endif