#ifndef _WALK_BEHAVIOUR_H
#define _WALK_BEHAVIOUR_H

#include <ActorBehaviour.h>
#include <Actor.h>
#include <ui/GameUI.h>

class WalkBehaviour : public ActorBehaviour
{
private:
    const MapObject * targetObj = NULL;

public:
    WalkBehaviour(Actor * actor, const MapObject * targetObj) : 
        ActorBehaviour(actor),
        targetObj(targetObj)
    {
        speed = 6.0f;
    }

    void Update(float dt)
    {
        if (targetObj->entity != NULL)
        {
            targetPos = targetObj->entity->transform.position;
        }
        else
        {
            targetPos = actor->map->GetPosition(targetObj->x + targetObj->width / 2, targetObj->z + targetObj->depth / 2);
        }
        Vector3 diff = targetPos - actor->transform.position;
        diff.y = 0.0f;
        if (Maths::LengthSq(diff) < 1.8f)
        {
            Done();
        }
    }
};

#endif