#ifndef _TALK_BEHAVIOUR_H
#define _TALK_BEHAVIOUR_H

#include <ActorBehaviour.h>
#include <Actor.h>
#include <ui/GameUI.h>

class TalkBehaviour : public ActorBehaviour
{
private:
    Actor * target = NULL;

public:
    TalkBehaviour(Actor * actor, Actor * target) : 
        ActorBehaviour(actor),
        target(target)
    {
        speed = 0.0f;
    }

    void Update(float dt)
    {
        if (GameUI::Current()->IsWriting())
        {
            actor->PlayAnimation(ActorAnim_Talk, 0.5f);
        }

        if (target == NULL || target->scene != actor->scene)
            return;

        if (Maths::IsWithinDistance(actor->transform.position, target->transform.position, 4.0f))
        {
            actor->Face(target);
            target->Face(actor);
        }
        else
        {
            Done();
        }
    }
};

#endif