#ifndef _TAKE_BEHAVIOUR_H
#define _TAKE_BEHAVIOUR_H

#include "InteractBehaviour.h"

class TakeBehaviour : public InteractBehaviour
{
public:
    TakeBehaviour(Actor * actor, Actor * target) : 
        InteractBehaviour(actor) 
    {
        SetTarget(target);
    }

    InteractState BeginAct()
    {
        MapEntityType holdItem = target->inventory.holdItem;
        if (holdItem != MapEntityType_None)
        {
            target->SetHoldItem(MapEntityType_None);
            if (target->type == MapEntityType_Player)
            {
                Save::SetInventory(&target->inventory);
            }
            actor->SetHoldItem(holdItem);
        }
        return InteractState_Act;
    }

    InteractState UpdateAct(float dt)
    {
        if (stateTime > 0.5f)
        {
            return InteractState_Done;
        }
        return InteractState_Act;
    }
};

#endif