#ifndef _ROAM_BEHAVIOUR_H
#define _ROAM_BEHAVIOUR_H

#include <ActorBehaviour.h>
#include <Scene.h>
#include <Maths.h>
#include <AttackManager.h>

class RoamBehaviour : public ActorBehaviour
{
private:
    float stillDuration;
    float randomness;
    float stillTimer;
    Vector3 lastPos = Vector3_ZERO;

public:
    RoamBehaviour(Actor * actor, float stillDuration = 1.3f, float randomness = 0.3f) 
        : ActorBehaviour(actor),
        stillDuration(stillDuration),
        randomness(randomness)
    {}

    virtual ~RoamBehaviour()
    {
        AttackManager::Remove(actor);
    }

    void Start() 
    {
        ActorBehaviour::Start();
        PickTargetPos();
        stillTimer = Maths::RandF(stillDuration);
    }

    void PickTargetPos()
    {
        static u8 pickDir = Direction_South;
        if (Maths::IsWithinDistance(actor->transform.position, actor->GetSpawnPos(), 6.0f))
        {
            Direction pickedDir = Direction_None;
            i16 x, z;
            actor->map->GetTile(actor->transform.position, &x, &z);
            u8 layer = actor->map->GetTileInfo(x, z).layer;
            for (u8 i=0; i<4; i++)
            {
                pickedDir = (Direction)(((i + pickDir++) % 4) + 1);
                if (actor->map->GetTileInfo(x + Directions::GetX(pickedDir), z + Directions::GetZ(pickedDir)).layer == layer)
                    break;
            }
            targetPos = actor->map->GetPosition(x + Directions::GetX(pickedDir), z + Directions::GetZ(pickedDir));
        }
        else
        {
            targetPos = actor->GetSpawnPos();
        }
        stillTimer = Maths::RandFMultiplier(stillDuration, randomness);
    }

    u8 UpdateState(float dt)
    {
        if (Maths::IsWithinDistance(lastPos, actor->transform.position, dt * actor->GetMoveSpeed()))
        {
            stillTimer -= dt;
            if (stillTimer <= 0.0f)
            {
                PickTargetPos();
            }
        }
        lastPos = actor->transform.position;
        return 0;
    }

    void OnCollision(Entity * other)
    {
        PickTargetPos();
    }
};

#endif