#ifndef _ATTACK_CHARGE_BEHAVIOUR_H
#define _ATTACK_CHARGE_BEHAVIOUR_H

#include "InteractBehaviour.h"

class KillBehaviour : public InteractBehaviour
{
public:
    KillBehaviour(Actor * actor, Actor * target) : 
        InteractBehaviour(actor)
    {
        SetTarget(target);
    }

    void Start()
    {
        speed = actor->GetMoveSpeed();
        InteractBehaviour::Start();
    }

    InteractState BeginAct()
    {
        actor->Strike();
        return InteractState_Act;
    }

    InteractState UpdateAct(float dt)
    {
        if (stateTime > 0.1f)
        {
            target->Die();
            return InteractState_Done;
        }
        return InteractState_Act;
    }
};

#endif