#ifndef _FOLLOW_BEHAVIOUR_H
#define _FOLLOW_BEHAVIOUR_H

#include <ActorBehaviour.h>
#include <Actor.h>

class FollowBehaviour : public ActorBehaviour
{
private:
    Entity * followEntity = NULL;

public:
    FollowBehaviour(Actor * actor, Entity * followEntity, float _speed) : 
        ActorBehaviour(actor),
        followEntity(followEntity)
    {
        speed = _speed;
    }

    void Start()
    {
        ActorBehaviour::Start();
        actor->SetCollision(CollisionMode_None);
        actor->SetMaxGradient(100.0f);
    }

    void Update(float dt)
    {
        if (followEntity == NULL || followEntity->scene == NULL)
            return;

        targetPos = followEntity->transform.position - followEntity->transform.Forwards() * 2.0f;
    }

    void Stop()
    {
        actor->SetCollision(CollisionMode_Collide);
        actor->SetMaxGradient();
        ActorBehaviour::Stop();
    }
};

#endif