#ifndef _BLOCK_BEHAVIOUR_H
#define _BLOCK_BEHAVIOUR_H

#include <ActorBehaviour.h>
#include <Actor.h>
#include <ui/GameUI.h>
#include <Scene.h>

class ChaseBehaviour : public ActorBehaviour
{
private:
    float chaseRange;

public:
    ChaseBehaviour(Actor * actor, float chaseRange = 10.0f) : 
        ActorBehaviour(actor),
        chaseRange(chaseRange)
    {
    }

    virtual void Start() 
    {
        ActorBehaviour::Start();
        if (target == NULL)
        {
            target = actor->FindTarget();
        }
    }

    void Update(float dt)
    {
        if (target == NULL)
        {
            targetPos = actor->GetSpawnPos();
        }
        else
        {
            if (actor->IsWithinRange(target, chaseRange, minDot))
            {
                targetPos = target->transform.position;
            }
            else
            {
                targetPos = actor->GetSpawnPos();
            }
        }
    }
};

#endif