#ifndef _BLOCK_BEHAVIOUR_H
#define _BLOCK_BEHAVIOUR_H

#include <ActorBehaviour.h>
#include <Actor.h>
#include <ui/GameUI.h>
#include <Scene.h>

class BlockBehaviour : public ActorBehaviour
{
private:
    float strikeTime = 0.0f;
public:
    BlockBehaviour(Actor * actor) : 
        ActorBehaviour(actor)
    {
        speed = 0.0f;
        strikeTime = 1.0f;
    }

    void Update(float dt)
    {
        Entity * target = actor->scene->GetNearestEntity(actor->transform.position, ActorFaction_GOOD | ActorFaction_PLAYER, 15.0f);
        if (target != NULL)
        {
            actor->Face(target);
            if (strikeTime > 0.0f)
            {
                strikeTime -= dt;
            }

            if (Maths::IsWithinDistance(target->transform.position, actor->transform.position, 2.0f))
            {
                if (strikeTime <= 0.0f)
                {
                    actor->Strike();
                    strikeTime = 1.0f;
                }
            }
        }
    }
};

#endif