#ifndef _ATTACK_STRIKE_BEHAVIOUR_H
#define _ATTACK_STRIKE_BEHAVIOUR_H

#include "InteractBehaviour.h"

class AttackStrikeBehaviour : public InteractBehaviour
{
public:
    AttackStrikeBehaviour(Actor * actor, float strikeRange, float windupDuration = 1.0f) : 
        InteractBehaviour(actor)
    {
        interactRange = strikeRange;
        interactWindupDuration = windupDuration;
    }

    virtual void Start()
    {
        InteractBehaviour::Start();
    }

    InteractState BeginWindup()
    {
        actor->SetAnimation(ActorAnim_StrikeFore, 0.0f, interactWindupDuration);
        return InteractState_Windup;
    }

    InteractState BeginAct()
    {
        actor->Strike();
        return InteractState_Act;
    }

    InteractState UpdateAct(float dt)
    {
        targetPos = actor->transform.position;
        if (stateTime > 0.5f)
        {
            return InteractState_Done;
        }
        return InteractState_Act;
    }
};

#endif