#ifndef _ATTACK_CHARGE_BEHAVIOUR_H
#define _ATTACK_CHARGE_BEHAVIOUR_H

#include "InteractBehaviour.h"

class AttackChargeBehaviour : public InteractBehaviour
{
private:
    Vector3 chargeDir = Vector3_BACK;
    float chaseSpeed;
    float chargeSpeed;
    float chargeTime;

public:
    AttackChargeBehaviour(Actor * actor, float chaseSpeed, float chargeRange, float chargeSpeed, float chargeTime) : 
        InteractBehaviour(actor),
        chaseSpeed(chaseSpeed),
        chargeSpeed(chargeSpeed),
        chargeTime(chargeTime)
    {
        interactRange = chargeRange;
    }

    virtual void Start()
    {
        InteractBehaviour::Start();
        speed = chaseSpeed;
        runState = BehaviourRunState_RUNNING;
    }

    InteractState BeginAct()
    {
        speed = chargeSpeed;
        targetPos = target->transform.position;
        chargeDir = targetPos - actor->transform.position;
        chargeDir.y = 0.0f;
        chargeDir = Maths::Normalize(chargeDir);
        return InteractState_Act;
    }

    InteractState UpdateAct(float dt)
    {
        targetPos = actor->transform.position + chargeDir;
        if (stateTime > chargeTime)
        {
            return InteractState_Done;
        }
        return InteractState_Act;
    }
};

#endif