#ifndef _NPC_TEMPTRESS_H
#define _NPC_TEMPTRESS_H

#include "NPCActor.h"

class NPCTemptress : public NPCActor
{
public:
    NPCTemptress() : NPCActor(MapEntityType_Temptress) 
    {
        permadeath = true;
    }

    void LoadModel()
    {
        model.LoadModel("models/temptress.iqm", "models/blacksmith.iqm", 0.33f);
        model.SetMaterial("models/temptress.png", ACTOR_SHADER_PATH);
        NPCActor::LoadModel();
        radius = 0.8f;
        SetCollision(CollisionMode_Collide, Vector3(4, 4, 4), Vector3(0, 2, 0));
        collider->mass = 2.0f;
        faction = ActorFaction_EVIL;
        damage = 0;
    }

    bool TakeHit(Entity * other, u8 power)
    {
        if (((Actor*)other)->inventory.holdItem != MapEntityType_SwordParticulars)
            return false;

        return Actor::TakeHit(other, power);
    }
};

#endif