#ifndef _NPC_ACTOR_H
#define _NPC_ACTOR_H

#include <Actor.h>
#include <read/iqm/IqmReader.h>

class NPCActor : public Actor
{
protected:
    Entity * followEntity = NULL;
    
public:
    NPCActor(MapEntityType type) : Actor(type) 
    {
        faction = ActorFaction_GOOD;
        removeOnDeath = false;
    }

    virtual void LoadModel()
    {
        if (model.IsLoaded())
        {
            boneHold = model.FindBone("B_Weapon.L");
            if (boneHold == NULL)
            {
                boneHold = model.FindBone("B_Hand.L");
            }
        }
        Actor::LoadModel();
    }

    void Update(float dt)
    {
        Actor::Update(dt);
        if (transform.position.y < 0.3f)
        {
            transform.position.y = 0.3f;
        }
    }
};

#endif