#ifndef _ACTOR_OGRE_H
#define _ACTOR_OGRE_H

#include <Actor.h>
#include <read/iqm/IqmReader.h>
#include <Scene.h>
#include <random>
#include <Maths.h>
#include <behaviours/TargetingBehaviour.h>
#include <behaviours/ChaseBehaviour.h>
#include <behaviours/AttackStrikeBehaviour.h>
#include "AttackManager.h"

// Animations: Idle,Run,StrikeFore,Jump,Air,Land,Die

class ActorOgre : public Actor
{
protected:
    TargetingBehaviour * bTargeting = NULL;

public:
    ActorOgre() : Actor(MapEntityType_Ogre) 
    {
        faction = ActorFaction_EVIL;
        radius = 0.4f;
        moveSpeed = 3.0f;
        inventory.hearts = 20;
        model.fps = 15.0f;
        damage = 3;

        bTargeting = new TargetingBehaviour(this,
            new ChaseBehaviour(this, 8.0f),
            new AttackStrikeBehaviour(this, 3.0f, 0.15f),
            10.0f
        );
        SetHoldItem(MapEntityType_Axe);
        SetBehaviour(bTargeting);
    }

    virtual void LoadModel()
    {
        model.LoadModel("models/ogre.iqm", 0.4f);
        model.SetMaterial("models/ogre.png", ACTOR_SHADER_PATH);
        Actor::LoadModel();
    }
};

#endif