#ifndef _ACTOR_MINION_H
#define _ACTOR_MINION_H

#include <Actor.h>
#include <behaviours/TargetingBehaviour.h>
#include <behaviours/ChaseBehaviour.h>
#include <behaviours/RoamBehaviour.h>
#include <behaviours/AttackChargeBehaviour.h>
#include "AttackManager.h"
#include <read/iqm/IqmReader.h>

// Anims: Idle,Run,Die

class ActorMinion : public Actor
{
protected:
    TargetingBehaviour * bTargeting = NULL;

public:
    ActorMinion() : Actor(MapEntityType_Minion) 
    {
        faction = ActorFaction_EVIL;
        radius = 0.25f;
        inventory.hearts = 3;
        moveSpeed = 9.0f;
        damage = 1;

        bTargeting = new TargetingBehaviour(this,
            new RoamBehaviour(this, 0.1f),
            new AttackChargeBehaviour(this, 4.0f, 6.0f, 15.0f, 0.8f)
        );
        SetBehaviour(bTargeting);
    }

    virtual void LoadModel()
    {
        model.LoadModel("models/minion.iqm", "models/blacksmith.iqm", 0.26f);
        model.SetMaterial("models/minion.png", ACTOR_SHADER_PATH);
        Actor::LoadModel();
    }
};

#endif