#ifndef _ACTOR_FIREWIZARD_H
#define _ACTOR_FIREWIZARD_H

#include <Actor.h>
#include <read/iqm/IqmReader.h>
#include <Scene.h>
#include <random>
#include <Maths.h>
#include <behaviours/TargetingBehaviour.h>
#include <behaviours/ChaseBehaviour.h>
#include <behaviours/AttackStrikeBehaviour.h>
#include "AttackManager.h"

class ActorFireWizard : public Actor
{
protected:
    TargetingBehaviour * bTargeting = NULL;
    ChaseBehaviour * bChase = NULL;
    AttackStrikeBehaviour * bAttack = NULL;


public:
    ActorFireWizard() : Actor(MapEntityType_FireWizard) 
    {
        faction = ActorFaction_EVIL;
        radius = 0.4f;
        moveSpeed = 3.0f;
        inventory.hearts = 12;
        model.fps = 30.0f;
        damage = 1;

        bChase = new ChaseBehaviour(this, 20.0f);
        bChase->minDot = -0.4f;
        bChase->avoidEdges = true;
        bAttack = new AttackStrikeBehaviour(this, 8.0f, 0.5f);
        bChase->minDot = -0.8f;
        bAttack->avoidEdges = true;
        bTargeting = new TargetingBehaviour(this,
            bChase,
            bAttack,
            23.0f,
            0.5f
        );
        bTargeting->minDot = -0.4f;
        bTargeting->avoidEdges = true;
        SetHoldItem(MapEntityType_SwordIce);
        SetBehaviour(bTargeting);
    }

    void LoadModel()
    {
        model.LoadModel("models/firewizard.iqm", "models/blacksmith.iqm", 0.34f);
        model.SetMaterial("models/firewizard.png", ACTOR_SHADER_PATH);
        Actor::LoadModel();
    }

    bool TakeHit(Entity * other, u8 damage)
    {
        Actor * otherActor = (Actor*)other;
        if (MapEntityTypes::IsActor(otherActor->type))
        {
            if (otherActor->inventory.holdItem != MapEntityType_SwordFire)
            {
                return false;
            }
        }
        return Actor::TakeHit(other, damage);
    }
};

#endif