#ifndef _ACTOR_CHOOK_3_H
#define _ACTOR_CHOOK_3_H

#include "ActorChook.h"

class ActorChook3 : public ActorChook
{
public:
    ActorChook3() : ActorChook(MapEntityType_Chook3) 
    {
        inventory.hearts = 10;
        model.fps = 15.0f;
    }

    void SetBehaviours()
    {
        bTargeting = new TargetingBehaviour(this, 
            new RoamBehaviour(this, 1.0f), 
            new AttackChargeBehaviour(this, 3.0f, 50.0f, 18.0f, 1.0f), 
            10.0f, 2.0f, 100.0f
        );
        SetBehaviour(bTargeting);
    }

    void LoadModel()
    {
        model.LoadModel("models/chook.iqm", 0.7f);
        model.SetMaterial("models/chook3.png", ACTOR_SHADER_PATH);
        Actor::LoadModel();
    }

};

#endif