#ifndef _ACTOR_CHOOK_2_H
#define _ACTOR_CHOOK_2_H

#include "ActorChook.h"

class ActorChook2 : public ActorChook
{
public:
    ActorChook2() : ActorChook(MapEntityType_Chook2) 
    {
        inventory.hearts = 3;
        model.fps = 120.0f;
    }

    virtual void SetBehaviours()
    {
        bTargeting = new TargetingBehaviour(this, 
            new RoamBehaviour(this, 1.5f), 
            new AttackChargeBehaviour(this, 6.0f, 7.0f, 12.0f, 0.4f), 
            12.0f
        );
        SetBehaviour(bTargeting);
    }

    void LoadModel()
    {
        model.LoadModel("models/chook.iqm", 0.4f);
        model.SetMaterial("models/chook2.png", ACTOR_SHADER_PATH);
        Actor::LoadModel();
    }

};

#endif