#ifndef _ACTOR_CHOOK_H
#define _ACTOR_CHOOK_H

#include <Actor.h>
#include <read/iqm/IqmReader.h>
#include <Scene.h>
#include <random>
#include <Maths.h>
#include "AttackManager.h"
#include <behaviours/RoamBehaviour.h>
#include <behaviours/AttackChargeBehaviour.h>
#include <behaviours/TargetingBehaviour.h>

// Anims: Idle,Run,Die

class ActorChook : public Actor
{
protected:
    TargetingBehaviour * bTargeting = NULL;

public:
    ActorChook(MapEntityType type = MapEntityType_Chook) : Actor(type) 
    {
        faction = ActorFaction_EVIL;
        radius = 0.3f;
        inventory.hearts = 1;
        moveSpeed = 3.0f;
        damage = 1;
        SetBehaviours();
    }

    virtual void SetBehaviours()
    {
        bTargeting = new TargetingBehaviour(this, 
            new RoamBehaviour(this, 1.5f), 
            new AttackChargeBehaviour(this, 6.0f, 7.0f, 12.0f, 0.4f), 
            7.0f
        );
        SetBehaviour(bTargeting);
    }

    virtual void LoadModel()
    {
        model.LoadModel("models/chook.iqm", 0.34f);
        model.SetMaterial("models/chook.png", ACTOR_SHADER_PATH);
        Actor::LoadModel();
    }
};

#endif