#include <TestMapScene.h>
#include <Material.h>
#include <Camera.h>
#include <Input.h>

void TestMapScene::Init()
{
    map.Load("maps/maptest1.tmx");
    map.SetLayerMaterial(0, LayerType_Ground, "mats/sand.png");
    map.SetLayerMaterial(0, LayerType_Wall, "mats/sand_edge.png");
    map.SetLayerMaterial(1, LayerType_Ground, "mats/grass.png");
    map.SetLayerMaterial(1, LayerType_Wall, "mats/grass_edge.png");
    map.SetLayerMaterial(2, LayerType_Ground, "mats/grass_dk.png");
    map.SetLayerMaterial(2, LayerType_Wall, "mats/grass_dk_edge.png");
    AddEntity(&map);
}

void TestMapScene::Update(float dt)
{
    Scene::Update(dt);
    Camera * cam = Camera::Current();

    Vector3 position = cam->transform.position;
    position.y = 1.0f;
    Vector3 forwards = cam->transform.Forwards();
    float rotate = 0.0f;
    if (Input::IsKeyHeld('w'))
    {
        position += forwards * dt * 10.0f;
    }
    if (Input::IsKeyHeld('s'))
    {
        position -= forwards * dt * 10.0f;
    }
    if (Input::IsKeyHeld('a'))
    {
        angle -= dt * 100.0f;
    }
    if (Input::IsKeyHeld('d'))
    {
        angle += dt * 100.0f;
    }

    float rad = angle * DEG2RAD;
    cam->transform
        .SetPosition(position)
        .LookAt(position + Vector3(cosf(rad), 0.0f, sinf(rad)));
}