#ifndef _SWORD_GAME_SCENE_H
#define _SWORD_GAME_SCENE_H

#include <desstypes.h>
#include <Scene.h>
#include <TileMap.h>
#include <Player.h>
#include <MapEntityFactory.h>
#include <CollisionChecker.h>
#include <ui/GameUI.h>
#include <ui/UIOptions.h>
#include <ui/UIProgress.h>
#include <Camera.h>

class DebugOverlay;
class UIOptionsMenuCtrl;

struct ModMusicCue;

enum MessageWaitType
{
    MessageWaitType_None,
    MessageWaitType_Message,
    MessageWaitType_Talk
};

class SwordGameScene : public Scene, public TileMapLoadListener, public IOptionHandler
{
public:
    TileMap map;
    Player player;
    Camera cam;
    MapEntityFactory entityFactory;
    CollisionChecker collisionChecker;
    GameUI ui;
    UIOptions uiOptions;
    UIProgress uiProgress;
    UIOptionsMenuCtrl * optionsCtrl = NULL;
    Vector3 lookOffset = Vector3_ZERO;
    Vector3 camOffset = Vector3_ZERO;
    bool firstPerson = false;
    bool cameraLocking = true;
    char mapLoaded[MAP_NAME_LENGTH];
    DebugOverlay * debugOverlay = NULL;
    u8 attackerCount = 0;
    u16 attackIntensity = 0;
    bool showingOptions = false;
    MessageWaitType messageWaitType = MessageWaitType_None;
    Entity * talkTarget = NULL;
    bool spawnFromSavePoint = false;
    float gameTime = 0.0f;
    u8 optionPressCount = 0;

    void Init();

    void Update(float dt);

    void Render();

    void BeforeMapLoad();
    void OnMapLoaded(const char * mapPath);

    void OnUnload();

    void SetDefaultOptions();

    void OptionSelect(u8 index);
    void OptionBack();
    void HideOptions();

    inline float GetTime() const { return gameTime; }

};

#endif