#ifndef _SWORD_GAME_H
#define _SWORD_GAME_H

#include "Game.h"
#include <dessint.h>

class TileMap;

class SwordGame : public Game
{
private:
    SwordGame();

public:
    static SwordGame & Inst();
    static TileMap * GetTitleMap();

    void ToStartup();
    void ToTitle();
    void NewGame();
    void LoadGame();
    void LoadSelect(const char * loadName);
    void Died();
    void GameWin();
    void Credits();
    void Cooked();
    void Update(float dt);
    void LoadSettings();
    
    void OnUnloadScene(Scene * scene);
    void PreloadTitleMap();
    void PreloadMap(HashInt hash);

private:

    void StartGame();
};

#endif