#include "SwordGame.h"
#include "ui/ScreenStartup.h"
#include "ui/ScreenTitle.h"
#include "ui/ScreenLoadGame.h"
#include "ui/ScreenDied.h"
#include "ui/ScreenWon.h"
#include "ui/ScreenCredits.h"
#include <Save.h>
#include <MusicPlayer.h>
#include <SoundPlayer.h>
#include <Settings.h>
#include <loaders/MapPreloader.h>

SwordGame & SwordGame::Inst()
{
    static SwordGame instance;
    return instance;
}

SwordGame::SwordGame() : 
    Game("Sword of Unspoken Misc") 
{
    MusicPlayer::Inst().Load("data/music.xml");
    LoadSettings();
}

void SwordGame::ToStartup()
{
    SetScene(new ScreenStartup());
}

void SwordGame::ToTitle()
{
    RenderWindow::Current()->SetPostShader("shaders/post-title.dsh");
    SetScene(new ScreenTitle());
    Input::Inst().SetDiscovering(true);
}

void SwordGame::NewGame()
{
    Save::Clear();
    StartGame();
}

void SwordGame::LoadGame()
{
    Save::LoadFile();
    StartGame();
}

void SwordGame::LoadSelect(const char * loadName)
{
    SettingsData & settings = Settings::Load();
    settings.spawnFromSavePoint = false;
    Save::LoadFile(loadName);
    StartGame();
}

void SwordGame::Update(float dt)
{
#ifdef DEBUG
    if (Input::WasKeyPressed('`'))
    {
        bool dummy = true;
    }
#endif
}

void SwordGame::Died()
{
    MusicPlayer::Inst().Stop();
    SetScene(new ScreenDied());
}

void SwordGame::GameWin()
{
    SetScene(new ScreenWon());
}

void SwordGame::Credits()
{
    SetScene(new ScreenCredits());
}

void SwordGame::Cooked()
{
    SDL_OpenURL("https://daleblackwood.com/");
}

void SwordGame::OnUnloadScene(Scene * oldScene)
{
    if (oldScene != NULL)
    {
        delete oldScene;
    }
}

void SwordGame::LoadSettings()
{
    SettingsData & settings = Settings::Load();
    SoundPlayer::Inst().SetMuted(settings.soundMute);
    MusicPlayer::Inst().SetMuted(settings.musicMute);
    RenderWindow::Current()->SetDisplayMode(settings.graphicsHD ? DisplayMode_Modern : DisplayMode_Retro);
    RenderWindow::Current()->SetFullScreen(settings.windowed == false);
}

void SwordGame::StartGame()
{
    MapPreloader * preloader = MapPreloader::Current();
    if (preloader != NULL)
    {
        preloader->Unload();
    }
    RenderWindow::Current()->SetPostShader(NULL);
    Input::Inst().SetDiscovering(false);
    MusicPlayer::Inst().Stop();
    SetScene(new ScreenLoadGame());
}

void SwordGame::PreloadTitleMap()
{
    Save::LoadFile();
    HashInt mapHash = MapUtils::MapPathToHash("maps/town.tmx");
    HashInt saveMapHash = Save::GetSaveMap();
    if (saveMapHash > 0)
    {
        mapHash = saveMapHash;
    }
    PreloadMap(mapHash);
}

void SwordGame::PreloadMap(HashInt mapHash)
{
    MapPreloader * preloader = MapPreloader::Current();
    if (preloader != NULL && preloader->GetHash() == mapHash)
        return;
    preloader = new MapPreloader(mapHash, MapLoadFlag_NoCommands | MapLoadFlag_NoActors);
    preloader->SetCurrent();
}