#include "Settings.h"
#include <string>
#include <fstream>
#include <iostream>
#include <desslog.h>
#include <desslibs.h>
#include <FileSystem.h>

const char * SETTINGS_PATH = "settings.dat";

SettingsData Settings::data;
bool Settings::isLoaded = false;

SettingsData & Settings::Load()
{
    if (isLoaded == false)
    {
        Log_Info("Load settings\n");
        SDL_RWops * file = FileSystem::FileOpen(SETTINGS_PATH, "r+b");
        if (file)
        {
            if (FileSystem::FileRead(file, &data.soundMute, sizeof(bool), 1) == 0)
                return data;
            if (FileSystem::FileRead(file, &data.musicMute, sizeof(bool), 1) == 0)
                return data;
            if (FileSystem::FileRead(file, &data.graphicsHD, sizeof(bool), 1) == 0)
                return data;
            if (FileSystem::FileRead(file, &data.windowed, sizeof(bool), 1) == 0)
                return data;
            if (FileSystem::FileRead(file, &data.spawnFromSavePoint, sizeof(bool), 1) == 0)
                return data;
            FileSystem::FileClose(file);
        }
    }
    return data;
}

void Settings::Save()
{
    Log_Info("Save settings\n");
    SDL_RWops * file = FileSystem::FileOpen(SETTINGS_PATH, "w+b");
    if (file == NULL)
    {
        Log_Error("Couldn't save settings%s\n", SDL_GetError());
        return;
    }
    if (FileSystem::FileWrite(file, &data.soundMute, sizeof(bool), 1) == 0)
        return;
    if (FileSystem::FileWrite(file, &data.musicMute, sizeof(bool), 1) == 0)
        return;
    if (FileSystem::FileWrite(file, &data.graphicsHD, sizeof(bool), 1) == 0)
        return;
    if (FileSystem::FileWrite(file, &data.windowed, sizeof(bool), 1) == 0)
        return;
    if (FileSystem::FileWrite(file, &data.spawnFromSavePoint, sizeof(bool), 1) == 0)
        return;
    FileSystem::FileClose(file);
}


void Settings::Save(SettingsData newData)
{
    data = newData;
    Save();
}